@extends('backend.layouts.master')
@section('title', __('dashboard'))
@push('css')
	<link rel="stylesheet" href="{{ static_asset('admin/css/dropzone.min.css') }}">
@endpush
@section('content')
	<section class="oftions">
		<div class="container-fluid">
			<div class="row">
				<div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4">
					<div class="bg-white redious-border mb-4 p-20 p-sm-30">
						<div class="row">
							<div class="col-md-12 mb-3">
								<div class="analytics-content mb-1">
									<h4>{{ __('hello') }} {{ Auth()->user()->first_name }},</h4>
									<p>{{ __('empower_your_business_with') }} {{ setting('system_name') }}</p>
								</div>
							</div>
							<div class="col-md-12">
								<div class="analytics clr-6">
									<div class="analytics-icon">
										<i class="las la-check-double"></i>
									</div>
									@if ($active_subscription)
										<div class="analytics-content">
											<h4>{{ @$active_subscription->plan->name }}</h4>
											<p>{{ __('next_billing') }} :
												{{ Carbon\Carbon::parse($active_subscription->expire_date)->format('Y-m-d') }}
											</p>
										</div>
									@else
										<div class="analytics-content">
											<h4>{{ __('no_active_plan') }}</h4>
											<p>{{ __('next_billing') }}: </p>
										</div>
									@endif
								</div>
								@if (@Auth::user()->is_primary)
									<div class="text-center">
										<a href="{{ route('client.my.subscription') }}"
										   class="btn btn-sm sg-btn-primary gap-1  mt-20 mb-20">
											<span>{{ __('manage_subscription') }}</span>
										</a>
									</div>
								@endif
							</div>
						</div>
					</div>
				</div>
				<div class="col-xxl-9 col-xl-8 col-lg-8 col-md-8">
					<div class="row">
						<div class="col-xxl-4 col-xl-4 col-md-6 col-sm-6">
							<a href="{{ route('client.team.index') }}">
								<div class="bg-white redious-border mb-4 p-20 p-sm-30 analytics-box">
									<div class="analytics clr-6">
										<div class="analytics-icon">
											<svg width="32" height="32" viewBox="0 0 32 32" fill="none"
											     xmlns="http://www.w3.org/2000/svg">
												<g id="uil:users-alt">
													<path id="Vector"
													      d="M16.4026 16.2933C17.114 15.6775 17.6847 14.9158 18.0758 14.06C18.4669 13.2042 18.6693 12.2743 18.6693 11.3333C18.6693 9.56522 17.9669 7.86953 16.7167 6.61929C15.4664 5.36904 13.7707 4.66666 12.0026 4.66666C10.2345 4.66666 8.5388 5.36904 7.28856 6.61929C6.03832 7.86953 5.33594 9.56522 5.33594 11.3333C5.33593 12.2743 5.53834 13.2042 5.92944 14.06C6.32054 14.9158 6.89117 15.6775 7.6026 16.2933C5.73612 17.1385 4.15256 18.5034 3.04124 20.2247C1.92993 21.9461 1.3379 23.9511 1.33594 26C1.33594 26.3536 1.47641 26.6928 1.72646 26.9428C1.97651 27.1929 2.31565 27.3333 2.66927 27.3333C3.02289 27.3333 3.36203 27.1929 3.61208 26.9428C3.86213 26.6928 4.0026 26.3536 4.0026 26C4.0026 23.8783 4.84546 21.8434 6.34575 20.3431C7.84604 18.8429 9.88087 18 12.0026 18C14.1243 18 16.1592 18.8429 17.6595 20.3431C19.1597 21.8434 20.0026 23.8783 20.0026 26C20.0026 26.3536 20.1431 26.6928 20.3931 26.9428C20.6432 27.1929 20.9823 27.3333 21.3359 27.3333C21.6896 27.3333 22.0287 27.1929 22.2787 26.9428C22.5288 26.6928 22.6693 26.3536 22.6693 26C22.6673 23.9511 22.0753 21.9461 20.964 20.2247C19.8527 18.5034 18.2691 17.1385 16.4026 16.2933ZM12.0026 15.3333C11.2115 15.3333 10.4381 15.0987 9.78032 14.6592C9.12253 14.2197 8.60984 13.595 8.30709 12.8641C8.00434 12.1332 7.92512 11.3289 8.07946 10.553C8.2338 9.77705 8.61477 9.06431 9.17418 8.5049C9.73359 7.94549 10.4463 7.56453 11.2222 7.41019C11.9982 7.25585 12.8024 7.33506 13.5333 7.63781C14.2642 7.94056 14.889 8.45325 15.3285 9.11105C15.768 9.76885 16.0026 10.5422 16.0026 11.3333C16.0026 12.3942 15.5812 13.4116 14.831 14.1618C14.0809 14.9119 13.0635 15.3333 12.0026 15.3333ZM24.9893 15.76C25.8426 14.7991 26.4 13.6121 26.5943 12.3418C26.7887 11.0715 26.6118 9.7721 26.085 8.6C25.5581 7.4279 24.7037 6.43306 23.6246 5.73523C22.5455 5.0374 21.2877 4.66632 20.0026 4.66666C19.649 4.66666 19.3098 4.80714 19.0598 5.05719C18.8097 5.30724 18.6693 5.64638 18.6693 6C18.6693 6.35362 18.8097 6.69276 19.0598 6.94281C19.3098 7.19285 19.649 7.33333 20.0026 7.33333C21.0635 7.33333 22.0809 7.75476 22.831 8.5049C23.5812 9.25505 24.0026 10.2725 24.0026 11.3333C24.0007 12.0336 23.815 12.7212 23.464 13.3272C23.113 13.9332 22.6091 14.4365 22.0026 14.7867C21.8049 14.9007 21.6398 15.0635 21.5231 15.2597C21.4064 15.4558 21.3419 15.6785 21.3359 15.9067C21.3304 16.133 21.3825 16.3571 21.4875 16.5577C21.5925 16.7583 21.7468 16.9289 21.9359 17.0533L22.4559 17.4L22.6293 17.4933C24.2365 18.2556 25.5924 19.4613 26.5372 20.9684C27.4821 22.4755 27.9767 24.2212 27.9626 26C27.9626 26.3536 28.1031 26.6928 28.3531 26.9428C28.6032 27.1929 28.9423 27.3333 29.2959 27.3333C29.6496 27.3333 29.9887 27.1929 30.2387 26.9428C30.4888 26.6928 30.6293 26.3536 30.6293 26C30.6402 23.9539 30.1277 21.939 29.1406 20.1467C28.1534 18.3545 26.7244 16.8444 24.9893 15.76Z"
													      fill="#3F52E3"></path>
												</g>
											</svg>
										</div>
										<div class="analytics-content">
											<h4>{{ $usages['team'] }}
												/{{ $active_subscription->team_limit == -1 ? __('unlimited') : $active_subscription->team_limit }}
											</h4>
											<p>{{ __('team_member') }}</p>
										</div>
									</div>
								</div>
							</a>
						</div>
						<div class="col-xxl-4 col-xl-4 col-md-6 col-sm-6">
							<a href="{{ route('client.posts.index', ['type' => 'index']) }}">
								<div class="bg-white redious-border mb-4 p-20 p-sm-30 analytics-box">
									<div class="analytics clr-2">
										<div class="analytics-icon">
											<svg width="28" height="28" viewBox="0 0 24 24"
											     xmlns="http://www.w3.org/2000/svg" data-name="Layer 1">
												<path d="m23.121.879c-1.17-1.17-3.072-1.17-4.242 0l-6.707 6.707c-.756.755-1.172 1.76-1.172 2.828v1.586c0 .552.447 1 1 1h1.586c1.068 0 2.073-.417 2.828-1.172l6.707-6.707c1.164-1.117 1.164-3.126 0-4.243zm-1.414 2.828-6.707 6.707c-.378.378-.88.586-1.414.586h-.586v-.586c0-.526.214-1.042.586-1.414l6.707-6.707c.391-.39 1.023-.39 1.414 0 .388.372.388 1.042 0 1.414zm-9.707 14.293c-.553 0-1-.447-1-1s.447-1 1-1h3c.553 0 1 .447 1 1s-.447 1-1 1zm8-4v5c0 2.757-2.243 5-5 5h-10c-2.757 0-5-2.243-5-5v-14c0-2.757 2.243-5 5-5h9c.553 0 1 .448 1 1s-.447 1-1 1h-9c-1.654 0-3 1.346-3 3v14c0 1.654 1.346 3 3 3h10c1.654 0 3-1.346 3-3v-5c0-.553.447-1 1-1s1 .447 1 1zm-10.833-2.333-1.687 1.687c-.431.431-.995.648-1.561.648-.533 0-1.066-.193-1.491-.582l-.669-.579c-.417-.362-.462-.994-.101-1.411.363-.419.994-.461 1.411-.101l.689.598c.103.093.228.092.307.013l1.687-1.687c.391-.391 1.023-.391 1.414 0s.391 1.023 0 1.414zm0-4.96-1.687 1.687c-.431.431-.995.648-1.561.648-.533 0-1.066-.193-1.491-.582l-.669-.579c-.417-.362-.462-.994-.101-1.411.363-.418.994-.461 1.411-.101l.689.598c.103.094.228.092.307.013l1.687-1.687c.391-.391 1.023-.391 1.414 0s.391 1.023 0 1.414zm0 8.546c.391.391.391 1.023 0 1.414l-1.687 1.687c-.431.431-.995.648-1.561.648-.533 0-1.066-.193-1.491-.582l-.669-.579c-.417-.362-.462-.993-.101-1.411.363-.417.994-.462 1.411-.101l.689.598c.103.093.228.092.307.013l1.687-1.687c.391-.391 1.023-.391 1.414 0z" fill="#3F52E3"/>
											</svg>
										</div>
										<div class="analytics-content">
											<h4>{{ $usages['post'] }}
												/{{ $active_subscription->post_limit == -1 ? __('unlimited') : $active_subscription->post_limit }}
											</h4>
											<p>{{ __('total_post') }}</p>
										</div>
									</div>
								</div>
							</a>
						</div>
						<div class="col-xxl-4 col-xl-4 col-md-6 col-sm-6">
							<div class="bg-white redious-border mb-4 p-20 p-sm-30 analytics-box">
								<div class="analytics clr-6">
									<div class="analytics-icon">
										<i class="las la-users"></i>
									</div>
									<div class="analytics-content">
										<h4>{{ ReadableNumbers::make($usages['total_social_profile']) }} /{{ $active_subscription->profile_limit == -1 ? __('unlimited') : $active_subscription->profile_limit }}</h4>
										<p>{{ __('social_profile') }}</p>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xxl-4 col-xl-4 col-md-6 col-sm-6">
							<a href="{{ route('client.posts.index', ['type' => 'index']) }}">
								<div class="bg-white redious-border mb-4 p-20 p-sm-30 analytics-box">
									<div class="analytics clr-3">
										<div class="analytics-icon">
											<svg width="28" height="28" xmlns="http://www.w3.org/2000/svg" id="Layer_1"
											     data-name="Layer 1" viewBox="0 0 24 24">
												<path d="m10,5.857h2v5.731l-4.372,2.429-.971-1.748,3.343-1.857v-4.555ZM2,11C2,6.038,6.037,2,11,2c4.109,0,7.694,2.775,8.716,6.749,0,0,0,0,0,.001.106.409.175.828.221,1.25h2c-.054-.591-.137-1.178-.284-1.75,0,0,0,0,0-.002C20.402,3.392,16.022,0,11,0,4.935,0,0,4.935,0,11c0,4.762,3.037,8.961,7.557,10.45.792.261,1.611.426,2.443.501v-2.03c-.618-.068-1.229-.177-1.818-.371-3.697-1.218-6.182-4.654-6.182-8.55Zm22,5v8h-12v-8c0-1.103.897-2,2-2v-2h2v2h4v-2h2v2c1.103,0,2,.897,2,2Zm-2,6v-4h-8v4h8Z"
												      fill="#3F52E3"/>
											</svg>
										</div>
										<div class="analytics-content">
											<h4>{{ReadableNumbers::make($usages['scheduled_post']) }}</h4>
											<p>{{ __('scheduled_post') }}</p>
										</div>
									</div>
								</div>
							</a>
						</div>
						<div class="col-xxl-4 col-xl-4 col-md-6 col-sm-6">
							<a href="{{ route('client.posts.index', ['type' => 'index']) }}">
								<div class="bg-white redious-border mb-4 p-20 p-sm-30 analytics-box">
									<div class="analytics clr-4">
										<div class="analytics-icon">
											<i class="las la-file-alt"></i>
										</div>
										<div class="analytics-content">
											<h4>{{ReadableNumbers::make($usages['draft_post']) }}</h4>
											<p>{{ __('draft_post') }}</p>
										</div>

									</div>
								</div>
							</a>
						</div>
						<div class="col-xxl-4 col-xl-4 col-md-6 col-sm-6">
							<a href="{{ route('client.posts.index', ['type' => 'index']) }}">
								<div class="bg-white redious-border mb-4 p-20 p-sm-30 analytics-box">
									<div class="analytics clr-2">
										<div class="analytics-icon">
											<i class="las la-bullhorn"></i>
										</div>
										<div class="analytics-content">
											<h4>{{ ReadableNumbers::make($usages['public_post']) }}</h4>
											<p>{{ __('published_post') }}</p>
										</div>
									</div>
								</div>
							</a>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xl-6 col-md-6">
					<div class="bg-white redious-border mb-4 pt-20 p-30">
						<div class="section-top">
							<h4>{{ __('post_statistic') }}</h4>
						</div>
						<div class="statistics-report">
							<div class="row">
							</div>
						</div>
						<div class="statistics-report-chart">
							<canvas id="post_statistic"></canvas>
						</div>
					</div>
				</div>
				<div class="col-xl-6 col-md-6">
					<div class="bg-white redious-border mb-4 pt-20 p-30">
						<div class="section-top">
							<h4>{{ __('today_scheduled_post') }}</h4>
						</div>
						<div class="statistics-report">
							<div class="row">
							</div>
						</div>
						<div class="statistics-report-chart">
							<canvas id="today_scheduled_post"></canvas>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<div class="bg-white redious-border mb-4 pt-20 p-30">
						<div class="section-top">
							<h4>{{ __('scheduled_post') }}</h4>
						</div>
						<div class="statistics-report">
							<div class="row">
							</div>
						</div>
						<div class="statistics-report-chart">
							<canvas id="scheduled_post_statistic"></canvas>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<input type="hidden" id="today_scheduled_post_charts_data" value="{{ json_encode($today_scheduled_post_charts) }}">
	<input type="hidden" id="scheduled_post_charts_data" value="{{ json_encode($scheduled_post_charts) }}">
	<input type="hidden" id="post_statistic_charts_data" value="{{ json_encode($post_statistic_charts) }}">
@endsection
@push('js')
	<script src="{{ static_asset('admin/js/chart.min.js') }}"></script>
@endpush
@push('js')
	<script src="{{ static_asset('admin\js\custom\dashboard\client_dashboard_chart.js') }}"></script>
@endpush
